#version 130
#extension GL_EXT_gpu_shader4 : enable
//quadtree truchet many ringsMod01.fsh  by   abje 

//https://www.shadertoy.com/view/lttfRX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define HASHSCALE3 vec3(.6531, .5563, .7498)

//subdivision limit
#define limit 3.0
#define thickness 0.01
//how many subdivisions
#define subs 0.4

float hash13(vec3 p3)
{
	p3  = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract(10.0*fract((p3.x + p3.y) * p3.z*15.3023+0.434));
}

vec2 repeat(float a, float b) {
    return vec2(mod(a,b),mod(-a,b));
}

float ripple(vec2 p, float rep) {
    p -= max(dot(p,vec2( 1,1)),0.0);
    p -= max(dot(p,vec2(-1,1)),0.0)*vec2(-1,1);
    
    float l0 = length(p+0.5);
    
    float l2 = floor(l0/rep);
    
    vec2 lens = repeat(l0+rep*0.5,rep);
    
    float len = 1.0;
    
    float s = rep*(0.5+l2);
    
    float a = s*s-0.5;
    if (a > 0.0)
    {
        vec2 p1 = sqrt(a*0.5)*vec2(1,-1);
        
        vec2 p2=p1+0.5;
        
        if (dot(vec2(-p2.y,p2.x),p+0.5)>0.0)
        {
            lens.y = length(p-p1);
        }
    }
    
    return min(lens.x,lens.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float T = iTime*0.1;
    //normalize fragCoord to uv
    vec2 uv = (fragCoord*2.0-iResolution.xy)/iResolution.y
    //some random movement stuff
        +vec2(sin(T*6.28*exp2(-T)),cos(T*6.28*exp2(-T)))*T*4.0;
	
    //lp is position in cell from 0 to 1
    vec2 lp = fract(uv);
    //fp is cell's bottom left corner position
    vec2 fp = floor(uv);
    //i is quadtree subdivisions
    float i;
    //size is the size of the quadtree cell
    float size = 1.0;
    //this is the quadtree loop, finds where the pixel lands on the quadtree
    for (i = 0.0; i < limit; i++) {
        //breaks randomly out of the loop (creates a random quadtree)
        float rand = hash13(vec3(fp,i));
        if (rand > subs||i==limit) {
            break;
        }
        
        //doubles the cell position
        lp *= 2.0;
        //checks which cell in the subdivision the pixel lands on
        vec2 q = step(1.0,lp);
        //if lp is over 1 subtract by 1
        lp -= q;
        //half size because of subdivision
        size *= 0.5;
        //moves to new cell position
        fp += q*size;
    }
    //flips the truchet cell randomly
    float rand = hash13(vec3(fp,-i-1.0));
    if (rand < 0.5) lp.x = 1.0-lp.x;
    
    float a = exp2(i-limit-1.0);
    //length to bottom left corner, or top right (whichever is closest
    float t = length(lp-step(1.0,lp.x+lp.y));
    //repeats the length with mod to make many rings
    float len = ripple(lp-0.5,a*2.0);//abs(mod(t,a*2.0)-a);
    
    //normalize len
    len *= size;
    len -= thickness;
    
    //antialiasing
    float mask = clamp(len*iResolution.y*0.5-0.5,0.0,1.0);
    
    vec2 p2 = abs(lp-0.5);
    float e = min((1.0-max(p2.x,p2.y)*2.0)*size*iResolution.y*0.125,1.0);
    
    vec3 col1 = texture(iChannel0,uv*0.2).rgb;
    col1 = mix(vec3(0.3,0.8,0.5),col1,e);
    //shadows
    col1 /= max(1.0,3.0-len*90.0);
    
    vec3 col2 = mix(vec3(0,0.5,0.8),vec3(0.5,0.2,0.76),sin(len/thickness*2.0+1.0));
    
    fragColor = vec4(mix(col2,col1,mask),1);
    return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.